﻿using System;
using System.Collections.Specialized;
using System.IO;
using System.Reflection;
using System.Web;
using System.Web.Mvc;
using System.Web.Routing;
using System.Web.SessionState;
using HIPS.CommonSchemas.PatientIdentifier;
using HIPS.Web.Test.Common;
using HIPS.Web.UI;
using HIPS.Web.UI.Controllers;
using Microsoft.VisualStudio.TestTools.UnitTesting;
using Moq;
using OpenQA.Selenium;
using OpenQA.Selenium.Remote;
using SpecsFor.Mvc;
using HIPS.Web.Test.Integration.SeleniumJquery;

namespace HIPS.Web.Test.Integration
{
    [TestClass]
    public class PatientSummaryViewTests
    {
        private static MvcWebApp App { get; set; }

        [ClassInitialize]
        public static void ClassInitialize(TestContext testContext)
        {
            App = new MvcWebApp();
        }

        [TestMethod]
        public void NonExistentUrl_ReturnsCustom404()
        {
            var a = System.Security.Principal.WindowsIdentity.GetCurrent().Name;
            string hospitalCode = "RCH";
            Mrn patientIdentifier = TestAssistant.GetKnownPatientIdentifier(KnownPatients.PhilipLudwigHobbs);

            //act + assert
            App.NavigateTo<PcehrViewController>(c => c.PatientSummary(hospitalCode, patientIdentifier.Value));

            Assert.IsFalse(App.Browser.FindJQueryElement(jQueryBy.jQuery(".tab-pane:last")).Displayed, "Patient Summary tab selection is broken. Expected first Tab Pane to be displayed initially.");
            App.Browser.FindJQueryElement(jQueryBy.jQuery("#navTabs li:last a")).Click(); // Click last tab (SHS Documents)
            Assert.IsTrue(App.Browser.FindJQueryElement(jQueryBy.jQuery(".tab-pane:last")).Displayed, "Patient Summary tab selection is broken. Expected last Nav Tab to display last Tab Pane.");

            Assert.IsFalse(App.Browser.FindJQueryElements(jQueryBy.jQuery(".tab-pane:last .datatable tbody tr")).Count == 8, "Patient Summary pagination is broken. Expected 10 SHS Documents on Page 1.");
            App.Browser.FindJQueryElement(jQueryBy.jQuery(".tab-pane:last .pagination li:last")).Click(); // Click "Last" pagination button
            Assert.IsTrue(App.Browser.FindJQueryElements(jQueryBy.jQuery(".tab-pane:last .datatable tbody tr")).Count == 8, "Patient Summary pagination is broken. Expected 8 SHS Documents on Page 2.");

            Assert.IsFalse(App.Browser.FindJQueryElement(jQueryBy.jQuery(".modal")).Displayed, "Patient Summary modal broken. Expected modal to be hidden initially.");
            App.Browser.FindJQueryElement(jQueryBy.jQuery(".tab-pane:last .datatable tbody tr:last a.document-link")).Click(); // Click last document link ("TestData 2")
            Assert.IsTrue(App.Browser.FindJQueryElement(jQueryBy.jQuery(".modal")).Displayed, "Patient Summary modal broken. Expected modal to be shown on Document Link click.");
        }
    }
}
